*******************************************************************************
*                         680xx Grundprogramm turtle                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                              Turtle Befehle                                 *
*******************************************************************************


thoch:                          * Hebe
 clr.b turdo(a5)
rts

trunter:                        * Senke
 move.b #1,turdo(a5)
rts

turtab:
 dc.b 0,5,12,17,24,29,36,41

turtab1:
 dc.b $fa,$fd,$ff,$fa,$00
 dc.b $d3,$d0,$d0,$d4,$d4,$d3,$00
 dc.b $fe,$f9,$fd,$fe,$00
 dc.b $d7,$d2,$d2,$d0,$d0,$d7,$00
 dc.b $fc,$fb,$f9,$fc,$00
 dc.b $d5,$d6,$d6,$d2,$d2,$d5,$00
 dc.b $f8,$ff,$fb,$f8,$00
 dc.b $d1,$d4,$d4,$d6,$d6,$d1,$00

turtle:                         * Turtle auf Screen ausgeben
 movem.l d0/a0,-(a7)
 move tur1phi(a5),d0            * Alter Wert
 ext.l d0                       * Auf 32 Bit
 divu #45,d0                    * In 45-Grad-Schritten
 and #7,d0                      * Sicherheitshalber
 move.b turtab(pc,d0),d0        * Zeiger auf Tabelle
 lea turtab1(pc,d0),a0          * Anfang Werte
turlp:
 move.b (a0)+,d0
 beq.s turend                   * Wenn 0, dann Ende
 bsr cmd                        * Kurzvektor ausgeben
bra.s turlp                     * Und Schleife fortsetzen
turend:
 movem.l (a7)+,d0/a0
rts

grapoff:
 move.b #1,first(a5)            * Keine Turtle mehr sichtbar
rts

hide:                           * Turtle aus
 tst.b first(a5)
 beq.s hide1
 bsr.s firsttime                * Erster Aufruf
hide1:
 clr.b flip(a5)                 * Keine Seitenumschaltung mehr
 clr.b flip1(a5)
 clr.b viewpage(a5)             * Seite 0
bra aktpage                     * als Leseseite

show:                           * Turtle an
 tst.b first(a5)
 bne.s firsttime
 move.b #1,flip(a5)             * Seitenumschaltung an
 move.b #1,flipcnt(a5)
 clr.b viewpage(a5)             * Leseseite = 0
 clr.b wrtpage(a5)              * Schreibseite = 0
bra aktpage

firsttime:                      * Erster Aufruf der Turtle
 movem.l d0-d3,-(a7)
 move #256,d1                   * X = 256
 move #256,d2                   * Y = 256
 moveq #90,d3                   * Phi = 90 Grad
 bsr.s tmove                    * Turtle positionieren
 clr.b wrtpage(a5)              * Seite 0 wird eingestellt
 clr.b viewpage(a5)
 bsr aktpage                    * Seite anwhlen
 movem.l (a7)+,d0-d3
rts

tmove:                          * Turtle positionieren
 movem.l d1-d2,-(a7)
 asl #4,d1                      * x*16
 asl #4,d2                      * y*16
 move d1,turx(a5)
 move d2,tury(a5)               * X, Y ablegen
 move d3,d0
 bsr adj360                     * Winkel normieren
 move d0,turphi(a5)             * OK
 move.b #1,flip(a5)             * Schnellste Rate
 move.b #1,flipcnt(a5)
 clr.b first(a5)                * Nicht mehr first
 movem.l (a7)+,d1-d2
rts

aufk:                           * Aufkurs Winkel d0.w
 clr turphi(a5)
tdrehe:                         * d0.w = deltaphi
 tst.b first(a5)
 beq.s tdreh1
 bsr.s firsttime                * First, falls erster Aufruf
tdreh1:
 add turphi(a5),d0              * phi = phi+deltaphi
 bsr adj360
 move d0,turphi(a5)             * Ergebnis Drehung
bra autoflip

tschreite:                      * d0 = delta w
 asl.w #4,d0
tschr16tel:                     * Feine Schritte
 tst.b first(a5)
 beq.s tsch1
 bsr.s firsttime                * Eventuell first
tsch1:
 movem.l d1-d4,-(a7)
 move turx(a5),d1               * Alte Position
 move tury(a5),d2
 move d0,d3
 move turphi(a5),d0
 bsr cos
 muls d3,d0
 divs #256,d0
 add d0,turx(a5)                * cos256(phi)*dw/256+xold
 move turphi(a5),d0
 bsr sin
 muls d3,d0
 divs #256,d0
 add d0,tury(a5)                * sin(phi)*dw/256+yold
 tst.b turdo(a5)
 beq.s tsch2
 asr #4,d1                      * /16
 asr #5,d2                      * /32
 bsr moveto                     * Alte Position fr drawto
 move turx(a5),d3
 move tury(a5),d4
 asr #4,d3                      * /16 in x-Richtung
 asr #5,d4                      * /32 in y-Richtung
 bsr drawt0                     * Linie zeichnen ohne getxy da bekannt
tsch2:
 movem.l (a7)+,d1-d4
bra autoflip                    * Flip-Mode

setturt:                        * Turtle zeichnen
 tst.b first(a5)
 bne carset                     * Ausgeschaltet
 movem.l d0-d2,-(a7)
 move tur1x(a5),d1
 move tur1y(a5),d2
 asr #4,d1
 asr #5,d2                      * Normieren
 bsr moveto                     * GDP positionieren
 move.b gdp+1*cpu.w,-(a7)       * Penstatus merken
 or.b #1,wrtpage(a5)
 bsr aktpage                    * Seite 1...3
 bsr erapen                     * Lschen
 bsr turtle                     * Alte Turtle lschen
 move turphi(a5),tur1phi(a5)
 move turx(a5),d1
 move tury(a5),d2
 move d1,tur1x(a5)              * Neue Werte = Alte Werte
 move d2,tur1y(a5)
 asr #4,d1
 asr #5,d2
 bsr moveto
 bsr setpen                     * Schreiben
 bsr turtle                     * Neue Turtle ausgeben
 and.b #%11111110,wrtpage(a5)
 bsr aktpage
 move.b (a7)+,gdp+1*cpu.w       * Penstatus zurck
 movem.l (a7)+,d0-d2
rts

getk:                           * Winkel nach d0
 move turphi(a5),d0
rts

aufxy:                          * d1 = x   d2 = y
 tst.b first(a5)                * Linie zeichnen zu absoluter Position
 beq.s auf1xy
 bsr firsttime                  * Eventuell First
auf1xy:
 movem.l d1-d4,-(a7)
 move d1,d3                     * X
 move d2,d4                     * und Y merken
 tst.b turdo(a5)
 beq.s auf1exe                  * Bei HEBE nicht zeichnen
 move turx(a5),d1
 move tury(a5),d2
 asr #4,d1                      * /16
 asr #5,d2                      * /32
 bsr moveto                     * Anfang Linie
 movem.l d3/d4,-(a7)
 asr #1,d4                      * Nur Wort gltg Rev 6.0
 bsr drawt0                     * Linie zeichnen ohne getxy, da bekannt
 movem.l (a7)+,d3/d4
auf1exe:
 asl #4,d3
 move d3,turx(a5)
 asl #4,d4
 move d4,tury(a5)               * Neue Position abgespeichert
 movem.l (a7)+,d1-d4
bra autoflip

korxy:                          * Position der Turtle holen
 move turx(a5),d1
 move tury(a5),d2
 asr #4,d1
 asr #4,d2
 ext.l d1                       * Langwort gltig
 ext.l d2
rts
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    